function out = H(u,Norder)
% Returns the Hermite polynomial of order Norder.
% using the recurrence relation H_n+1=2*u*H_n - 2*n*H_n-1

% (C) Copyright 2018
% All rights reserved
% Department of Imaging Physics
% Faculty of Applied Sciences
% Delft University of Technology
% Delft, The Netherlands   

Hold=u-u+1;
H=2*u;
Hnew=u-u;
if Norder==0
  out=Hold;
elseif Norder==1
  out=H;
elseif Norder>1
  for i=2:1:Norder		
    Hnew=2*u.*H-2*(i-1)*Hold;
	Hold=H;
	H=Hnew;
  end
	out=Hnew;
else
  out=Hnew;
end
end

